package service;


public class ComposedTransitionImpl extends ComposedTransition {
	ComposedState from,to;
	TransitionSystem<? extends State,? extends Transition> ts;
	/**
	 * Creates a new composed action
	 * @param name the name that identifies the action.
	 * @param ts the transition system associated to the action
	 * @param from the source state of the composed action
	 * @param to the target state of the composed action
	 */	
	public ComposedTransitionImpl(String name,TransitionSystem<? extends State,? extends Transition> ts,ComposedState from,ComposedState to){
		super(name,ts,from,to);
		this.from=from;
		this.to=to;
		this.ts=ts;
	}

	/**
	 * This method returns the hashCode of the composed action
	 * @return The result contains the hashCode of the composed action
	 */
public int hashCode() {
		final int prime = 31;
		int result = 0;
		result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
		result = prime * result + ((from == null) ? 0 : from.hashCode());
		result = prime * result + ((to == null) ? 0 : to.hashCode());
		result = prime * result + ((ts == null) ? 0 : ts.hashCode());
		return result;
	}
	/**
	 * This method compares a composed action with another object
	 * 
	 * @param obj the other object used by the comparison
	 * @return Return true if and only if obj is a ComposedAction and the name,the target state and the source state of the two ComposedAction are equals.
	 */
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (getClass() != obj.getClass())
			return false;
		ComposedTransitionImpl other = (ComposedTransitionImpl) obj;
		if (from == null) {
			if (other.from != null)
				return false;
		} else if (!from.equals(other.from))
			return false;
		if (to == null) {
			if (other.to != null)
				return false;
		} else if (!to.equals(other.to)){
			return false;
		} else if (!ts.equals(other.ts)){
			return false;
		}
		//checks name correspondence
		if(getName() == null){
			if (other.getName()!=null)
				return false;
		}else if (!getName().equals(other.getName())){
			return false;
		}
		return true;
	}
	/**
	 * Return the transition system associated with the composed action
	 * @return the transition system described above.
	 */
	public TransitionSystem<? extends State,? extends Transition> getService() {
		return ts;
	}
	/** This method returns the source state of the action
	 * @return the source state of the action
	 */
	public ComposedState getStateFrom() {
		return from;
	}
	/** This method returns the target state of the action
	 * @return the target state of the action
	 */
	public ComposedState getStateTo() {
		return to;
	}

}
